const isDarkMode = Boolean(window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches);

if (isDarkMode) {
    document.documentElement.style.backgroundColor = "black";
}

let hasInited = false;

function init() {
    if (!document.body)
        return;
    hasInited = true;
    if (isDarkMode) {
        document.body.classList.add("nightMode");
        document.body.classList.remove("dayMode");
    }
    window.addEventListener("click", e => {
        console.log("click", e.target.tagName);
        let anchor = e.target;
        while (anchor && anchor.tagName !== "A" && !anchor.href) {
            anchor = anchor.parentElement;
        }
        if (anchor) {
            e.stopImmediatePropagation();
            e.preventDefault();
            sendToApp({
               navigate: anchor.href
            });
            return false;
        }
    }, true);
}

function sendToApp(message) {
    console.log("send-to-app", message);
    if (window.webkit && webkit.messageHandlers.dreadmsg) {
        webkit.messageHandlers.dreadmsg.postMessage(message);
    }
}

function getUser() {
    const r = window.___r;
    const username = r ? r.user.name : "";
    if (!username) {
        return {
            user: { name: "" },
            channels: []
        };
    }
    const account = r.accounts[username];
    const user = {
        name: username,
        icon: account.iconImage
    };
    const channels = Object.entries(___r.subreddits).map(([k, v]) => ({
        name: v.displayName || k,
        header: v.title || ("/r/" + (v.displayName || k)),
        link: v.url,
        icon: v.iconImage,
        summary: v.publicDescription || v.headerTitle
    })).filter(x => x.link.startsWith("/r/"));
    return JSON.stringify({
        user,
        channels
    });
}

function getCookies() {
    return document.cookie;
}

function setCookies(cookies) {
    document.cookie = cookies;
}

addEventListener("pageshow", init);
addEventListener("load", init);
setTimeout(init, 0);

window.dreadctrl = { getUser, getCookies, setCookies, logout }
