<?php

function scanFolder($folderPath) {
    $files = scandir($folderPath);
    $result = array();

    foreach ($files as $file) {
        if ($file != "." && $file != "..") {
            $filePath = $folderPath . '/' . $file;

            if (is_dir($filePath)) {
                // Recursively scan subfolders
                $result = array_merge($result, scanFolder($filePath));
            } else {
                $extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));

                if ($extension == 'mp3' || $extension == 'ogg') {
                    $filename = pathinfo($file, PATHINFO_FILENAME);
                    $album = basename($folderPath);
                    $artist = basename(dirname($folderPath));
                    $metadata = findMetaData($folderPath, ['jpg', 'md']);
                    $cover = isset($metadata['jpg']) ? $metadata['jpg'] : null;
                    $readme = isset($metadata['md']) ? $metadata['md'] : null;
                    $modifiedDate = date("Y-m-d H:i:s", filemtime($filePath));

                    $track = '';
                    if (is_numeric(substr($filename, 0, 1))) {
                        $track = (int)substr($filename, 0, strpos($filename, ' '));
                        $filename = substr($filename, strpos($filename, ' ') + 1);
                    }

                    // Strip non-alphanumeric characters from the beginning of the name
                    $filename = preg_replace('/^[^a-zA-Z0-9]+/', '', $filename);

                    $result[] = array(
                        'name' => ucwords($filename),
                        'album' => ucwords($album),
                        'artist' => ucwords($artist),
                        'cover' => $cover,
                        'readme' => $readme,
                        'path' => $filePath,
                        'date' => $modifiedDate,
                        'track' => $track
                    );
                }
            }
        }
    }

    return $result;
}

function findMetaData($folderPath, $extensions) {
    $files = scandir($folderPath);
    $metadata = array();

    foreach ($files as $file) {
        $fileExtension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
        if (in_array($fileExtension, $extensions)) {
            $metadata[$fileExtension] = $folderPath . '/' . $file;
        }
    }

    return $metadata;
}

$folderPath = 'music';

$musicData = scanFolder($folderPath);
$jsonData = json_encode($musicData, JSON_PRETTY_PRINT);

echo $jsonData;

?>
