const isDarkMode = Boolean(window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches);

if (isDarkMode) {
	document.documentElement.style.backgroundColor = "black";
}

const dreadit = window.dreadit = {
	inited: false,
	isMobile: false,
	getUser: function() { return undefined }
}

function sendToApp(message) {
	console.log("send-to-app", message);
	if (window.webkit && webkit.messageHandlers.dreadmsg) {
		webkit.messageHandlers.dreadmsg.postMessage(message);
	}
}

dreadit.logout = function() {
	document.querySelector("form[action*=logout]").submit();
}

function init() {
	if (!document.body)
		return;
	dreadit.inited = true;
	if (isDarkMode) {
		document.body.classList.add("nightMode");
		document.body.classList.remove("dayMode");
	}
	if (window.location.hostname.includes("old.reddit.com")) {
		initWebsite();
	} else {
		dreadit.isMobile = true;
		initMobile();
	}
	overrideClicks();
}


function css(...styles) {
	const style = document.createElement("style");
	style.setAttribute("dreadcss", true);
	style.innerHTML = styles.join("\n");
	document.body.appendChild(style);
}

function initWebsite() {
	// mobile viewports
	document.head.querySelector("meta[name=viewport]")?.setAttribute("content", "width=device-width, initial-scale=1, maximum-scale=1")
	document.head.querySelector("link[ref=applied_subreddit_stylesheet]")?.remove()

	// tab menu to select switch
	const tabmenu = document.querySelector("ul.tabmenu");
	if (tabmenu) {
		const lis = tabmenu?.querySelectorAll("li");
		const select = document.createElement("select");
		select.className = "selectmenu";
		tabmenu.parentElement.appendChild(select);
		for (const li of lis) {
			const a = li.querySelector("a")
			const href = a && a.href;
			if (!href) continue;
			const option = document.createElement("option");
			option.value = href;
			option.innerText = li.innerText;
			select.appendChild(option);
		}
		select.addEventListener("change", e => {
			location.href = e.target.value;
			sendToApp({
				navigate: e.target.value
			});
		});
		tabmenu.remove();
	}

	css`@media(max-width: 500px) {
		body > .footer-parent, body > .side, body > .listing-chooser, #sr-header-area, #header-bottom-right, #header-img, .mobile-web-redirect-bar {
			display: none !important;
		}
		
		body {
			font-family: system-ui;
			line-height: 1.4em;
		}
		
		body.nightMode {
			background-color: black;
			color: white;
		}
	
		html, body {
			overflow-x: hidden !important;
			width: 100vw;
		}
		
		a, .md {
			color: inherit !important;
		}
		
		body > .content {
			margin-left: 8px !important;
		}

		.thing {
			position: relative;
		}
		
		.link {
			border-bottom: 1px solid rgba(128, 128, 128,0.3);
			padding: 5px 0;
		}
		
		.link .midcol {
			float: right;
		}
		
		.link .rank {
			display: none;
		}
		
		.link .score {
			color: rgba(128, 128, 128, 0.9);
			padding: 3px 0;
		}
		
		.link.promoted {
			display: none;
		}
		
		.link .title {
			font-size: medium;
			margin-bottom: 6px;
			color: inherit;
			display: block;
			overflow: visible;
			line-height: 1.1em;
		}
		
		.linkflairlabel {
			padding: 2px 8px;
			border-radius: 1em;
			color: white;
			background-color: #AAA !important;
			border: none;
			display: inline-block;
			font-size: x-small;
		}
		
		.linkflairlabel .flairemoji {
			display: none;
		}
		
		.flat-list.buttons li {
			font-size: small;
			padding: 3px 10px;
			background-color: rgba(128,128,128,0.5);
			border-radius: 3px;
			margin: 3px;
		}
		
		.buttons li {
			display: none !important;
		}
		.buttons li.first {
			display: block !important;
			position: absolute;
			top: 0;
			left: 0;
			bottom: 0;
			right: 50px;
			z-index: 10;
			opacity: 0;
			padding: 0;
			margin: 0;
		}
		.buttons li.first > a {
			width: 100%;
			height: 100%;
			display: block;
			padding: 0;
			margin: 0;
		}
		
		.comment .arrow.down {
			margin-top: 13px;
		}
		
		.comment, .content .details {
			margin-left: 0;
		}
		
		.comment .child {
			border: none !important;
			margin: 0;
			padding: 3px 0 0 8px;
		}
		
		.comment .expand {
			position: absolute;
			left: 7px;
			font-size: medium;
		}
		
		.comment .midcol {
			margin-left: 0;
			width: 15px;
			float: right;
		}
		
		.md blockquote {
			color: #888888;
		}
		
		.commentarea > .sitetable > .comment {
			padding-left: 21px;
		}

		.comment > .entry {
			border: 1px solid rgba(128, 128, 128, 0.5);
			padding: 0 0 8px 8px;
			border-top: none;
			border-right: none;
			border-bottom-left-radius: 1em;
			margin: 0;
		}
		
		.commentarea .panestack-title, .commentarea .menuarea {
			margin: 3px 8px;
		}
		
		.nextprev {
			display: block;
			text-align: center;
			font-size: 0;
		}
		
		.nextprev .prev-button a, .nextprev .next-button a {
			padding: 8px 20px;
			font-size: medium;
			text-transform: uppercase;
		}
		
		.comments-page a.thumbnail {
			position: relative;
			display: none;
		}
		
		.pagename {
			font-variant: initial;
			font-size: x-large;
			vertical-align: baseline;
			text-transform: capitalize;
			display: inline-block;
			padding: 1.5em 0 0.6em;
		}
		
		div#header {
			border: none;
			background: none;
			padding: 8px 8px 0;
		}
		
		.tabmenu li a {
			background: none !important;
			border: none !important;
		}
		
		a#header-img-a {
			position: absolute;
			right: 8px;
			bottom: 0;
		}
		
		#header-bottom-left .tabmenu {
			overflow-x: auto;
			overflow-y: visible;
			width: 100vw;
		}
		
		#header-bottom-left .tabmenu li {
			font-size: medium;
			padding: 5px 15px;
			border-radius: 3px;
			background-color: rgba(128,128,128,0.5);
			margin: 0 3px 10px 0;
			display: inline-block;
		}
		
		.entry .expando-button {
			display: none;
		}
		
		.comments-page #header .tabmenu {
			display: none;
		}
		
		.comments-page .top-matter a.title {
			font-size: x-large;
			margin: 8px 0;
		}
		
		.entry .tagline > a.subreddit {
			font-size: medium;
			color: inherit !important;
			opacity: 1.0;
			display: inline-block;
			padding: 8px 0 0;
		}
		
		.comments-page .linklisting .midcol {
			transform: scale(1.5);
			position: absolute;
			top: 26px;
			right: 8px;
		}
		
		.morecomments {
			display: block;
			padding: 8px 0;
			margin-top: -8px;
		}

		select.selectmenu {
			margin: 0 0 10px;
			border: none;
			background: none;
			font-family: inherit;
			font-size: medium;
			text-align: left;
			color: inherit;
			font-weight: bold;
			text-transform: capitalize;
			display: block;
		}

		.subreddit .usertext .md {
			background-color: rgba(128, 128, 128, 0.5);
		}

		.subreddits-page .subreddit .midcol {
			width: 6ch!important;
		}

		.subreddits-page .infobar {
			display: none;
		}

		.subreddits-page .searchpane {
			background: none !important;
			border: none !important;
			margin: 0 !important;
			padding: 0 !important;
		}

		.interstitial {
			max-width: 100%;
		}

		.interstitial .buttons {
			flex-direction: column;
			max-width: 100%;
			gap: 1em;
		}

		.interstitial-subreddit-description {
			background-color: rgba(128, 128, 128, 0.5);
		}

		input, select, textarea, .roundfield {
			max-width: 100% !important;
			width: 100% !important;
			box-sizing: border-box;
		}

		.roundfield { 
			background-color: rgba(128,128,128,0.2);
		}

		.message.recipient > .entry {
			color: inherit !important;
		}

		.content>#login>.split-panel {
			padding: 8px;
		}
	}`;

	dreadit.getUser = function() {
		const r = window.r;
		if (typeof r === "undefined") {
			return undefined;
		}
		const username = r.config.logged || undefined;
		if (!username) {
			return {
				username: "",
				channels: []
			};
		}
		const channels = [...document.querySelectorAll(".drop-choices.srdrop a")].map(x => x.innerHTML)
		return {
			username,
			channels
		};
	}
}

function initMobile() {
css`
	.XPromoPopupRpl {
		display: none !important;
	}

	.scroll-disabled {
		height: auto !important;
		overflow: auto !important;
		position: absolute !important;
	}

	.UseAppButton {
		display: none !important;
	}

	*[rel*=sponsored] {
		display: none;
	}

	article:has(*[rel*="sponsored"]) {
		display: none !important;
	}

	.dayMode .TopNav, .dayMode .TopNav:after {
		background-color: white !important;
	}

	.nightMode .TopNav, .nightMode .TopNav:after {
		background-color: black !important;
	}

	nav[class*=TopNav] {
		display: none;
	}

	button[class*=JoinButton] {
		display: none;
	}

	.NavFrame__below-top-nav {
		padding-top: 0 !important;
	}
`;
dreadit.getUser = function () {
		const r = window.___r;
		const username = r ? r.user.name : "";
		if (!username) {
			return {
				user: { name: "" },
				channels: []
			};
		}
		const user = {
			username,
			channels: []
		};
		const channels = Object.entries(___r.subreddits)
			.filter(x => x[1].url.includes("/r/"))
			.map(x => x[0]);
		return JSON.stringify({
			username,
			channels
		});
	}
}

function overrideClicks() {
	window.addEventListener("click", e => {
		console.log("click", e.target.tagName);
		let anchor = e.target;
		while (anchor && anchor.tagName !== "A" && !anchor.href) {
			anchor = anchor.parentElement;
		}
		if (anchor) {
			e.stopImmediatePropagation();
			e.preventDefault();
			sendToApp({
				navigate: anchor.href
			});
			return false;
		}
	}, true);
}

addEventListener("pageshow", init);
addEventListener("load", init);
setTimeout(init, 0);
