#!/usr/bin/python3

import os
import sys

def install_pillow():
    try:
        import PIL
    except ImportError:
        print("Installing Pillow...")
        os.system('pip3 install pillow')
    else:
        print("Pillow is already installed.")

def convert_png_to_jpg(folder_path):
    install_pillow()  # Check and install Pillow if needed

    from PIL import Image

    for filename in os.listdir(folder_path):
        if filename.endswith('.png'):
            png_path = os.path.join(folder_path, filename)
            folder_name = os.path.splitext(filename)[0]
            output_folder = os.path.join(folder_path, "jpg", folder_name)
            os.makedirs(output_folder, exist_ok=True)
            jpg_path = os.path.join(output_folder, 'Cover.jpg')

            # Open PNG image and convert to RGB
            png_image = Image.open(png_path).convert('RGB')

            # Save as JPEG
            png_image.save(jpg_path, 'JPEG')

    print("Conversion completed!")

if __name__ == '__main__':
    if len(sys.argv) == 2:
        folder = sys.argv[1]
        convert_png_to_jpg(folder)
    else:
        print("Usage: python png_to_jpg.py <folder_path>")
