extends CharacterBody3D

@export var speed := 7.0
@export var jump_power := 11.0

const GRAVITY = 25.0

var look_dir = Vector3.FORWARD
var time_in_air = 0.0
var spawn_pos = Vector3.ZERO

func _ready():
	spawn_pos = global_transform.origin
	

func _physics_process(delta):
	if is_on_floor():
		time_in_air = 0.0
	else:
		velocity.y -= GRAVITY * delta
		time_in_air += delta
		if global_transform.origin.y < -20.0:
			global_transform.origin = spawn_pos
		if velocity.y > 0.0 and not Input.is_action_pressed("ui_accept"):
			velocity.y *= 1.0 - dease(delta, 0.8)
			

	if Input.is_action_just_pressed("ui_accept") and time_in_air < 0.1:
		velocity.y = jump_power

	var input_dir = Input.get_vector("ui_left", "ui_right", "ui_up", "ui_down")
	var right = Vector3.RIGHT
	var forward = Vector3.FORWARD
	var cam = get_viewport().get_camera_3d()
	if cam:
		var cam_basis = cam.global_transform.basis
		right = cam_basis.x
		forward = right.cross(Vector3.UP)
	var direction = right * input_dir.x + forward * input_dir.y
	var velocity_to = velocity
	if direction.length_squared() > 0.2:
		velocity_to.x = direction.x * speed
		velocity_to.z = direction.z * speed
		look_dir = direction.normalized()
	else:
		velocity_to.x = move_toward(velocity_to.x, 0, speed)
		velocity_to.z = move_toward(velocity_to.z, 0, speed)
		
	velocity = velocity.lerp(velocity_to, dease(delta, 0.3))

	move_and_slide()
	transform.basis = transform.basis.slerp(Basis.looking_at(-look_dir), dease(delta, 0.2))


func dease(dt: float, sharpness: float) -> float:
	return clamp(1.0 - pow(1.0 - sharpness, dt * 60.0), 0.0, 1.0)
