extends CharacterBody3D

@export var target: Node3D = null
@export var distance = 7.0
@export var height = 1.5

var ground_y = 0.0
var turn = 0.0

func _physics_process(delta: float) -> void:
	if target == null:
		return
	
	var target_pos = target.global_transform.origin
	target_pos.y += 2.0
	
	if not target.is_on_floor() and target_pos.y > ground_y:
		target_pos.y = ground_y
	else:
		ground_y = lerp(ground_y, target_pos.y, 0.1)
		target_pos.y = ground_y
	
	var diff = global_transform.origin - target_pos
	diff.y = 0.0
	var offset = diff
	var length = offset.length()
	var too_far_away = length > distance * 2.0
	if length > 0.0:
		offset = offset.normalized() * distance
	else:
		offset = target.global_transform.basis.z * distance * 2.0
	
	offset.y = height
	
	var to_pos = target_pos + offset
	if to_pos.y < 0.0:
		to_pos.y = 0.0
	if too_far_away:
		to_pos.y = target_pos.y + height
	else:
		to_pos = global_transform.origin.lerp(to_pos, 0.1)
	
	if Input.is_key_pressed(KEY_COMMA):
		turn = -1.0
	elif Input.is_key_pressed(KEY_PERIOD):
		turn = 1.0
	if abs(turn) > 0.01:
		var turn_offset = to_pos - target_pos
		turn_offset = turn_offset.rotated(Vector3.UP, delta * turn * delta * -200.0)
		to_pos = target_pos + turn_offset
		turn *= 0.8
		
	global_transform.origin = to_pos
	var move = global_transform.origin - to_pos
	velocity = move * delta
	move_and_slide()
	look_at(target_pos)
