import os
import datetime
import argparse

def change_file_modification_date(path):
    # Check if the path is a file or a directory
    if os.path.isfile(path):
        # Get the timestamp of the new modification date
        timestamp = datetime.datetime(2020, 1, 1).timestamp()
        # Set the new modification date of the file
        os.utime(path, (timestamp, timestamp))
    elif os.path.isdir(path):
        # Recursively process all files and subdirectories in the directory
        for filename in os.listdir(path):
            change_file_modification_date(os.path.join(path, filename))

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Set all file modification dates in a folder and subfolders to 2020-01-01.')
    parser.add_argument('path', help='the path to the folder to modify')
    args = parser.parse_args()

    # Call the function with the input path argument
    change_file_modification_date(args.path)
