import os
import argparse
import datetime

def update_files_in_folder(dir_out, input_file):
    files_map = {}
    with open(input_file, 'r') as f:
        for line in f:
            k, v = line.strip().split('|')
            files_map[k] = v
    for foldername, subfolders, filenames in os.walk(dir_out):
        for filename in filenames:
            base_filename = os.path.basename(filename)
            if base_filename in files_map:
                file_path = os.path.join(foldername, filename)
                mod_time = datetime.datetime.strptime(files_map[base_filename], '%Y-%m-%d %H:%M:%S')
                mod_time_unix = mod_time.timestamp()
                os.utime(file_path, (mod_time_unix, mod_time_unix))
                

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Create a dictionary of filenames and dates in a given folder and subfolders')
    parser.add_argument('dir_out', type=str, help='the directory to scan')
    parser.add_argument('datefile', type=str, help='the date file to read in')

    args = parser.parse_args()

    if not os.path.isdir(args.dir_out):
        print(f"{args.dir_out} is not a valid directory.")
        exit(1)

    if not os.path.isfile(args.datefile):
        print(f"{args.datefile} is not a valid file.")
        exit(1)

    datefile = args.datefile
    update_files_in_folder(args.dir_out, datefile)

    print(f"Updated files in {args.dir_out} with dates from {datefile}")
