import os
import argparse
import datetime

def get_files_and_dates(dir_in, datefile):
    files_map = {}
    for foldername, subfolders, filenames in os.walk(dir_in):
        for filename in filenames:
            if filename[0] == '.':
                continue
            filepath = os.path.join(foldername, filename)
            mod_time = os.path.getmtime(filepath)
            mod_time_str = datetime.datetime.fromtimestamp(mod_time).strftime('%Y-%m-%d %H:%M:%S')
            base_filename = os.path.basename(filename)
            if base_filename in files_map:
                if mod_time_str < files_map[base_filename]:
                    files_map[base_filename] = mod_time_str
            else:
                files_map[base_filename] = mod_time_str
    with open(datefile, 'w') as f:
        for k, v in files_map.items():
            f.write(f"{k}|{v}\n")
            

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Create a dictionary of filenames and dates in a given folder and subfolders')
    parser.add_argument('dir_in', type=str, help='the directory to scan')
    parser.add_argument('--datefile', default="datefile.txt", required=False, type=str, help='the output file for the filename and date map')

    args = parser.parse_args()

    if not os.path.isdir(args.dir_in):
        print(f"{args.dir_in} is not a valid directory.")
        exit(1)

    datefile = args.datefile
    get_files_and_dates(args.dir_in, datefile)

    print(f"Read files in {args.dir_in} to {datefile}")
