<?php

// Include the getID3 library
require_once('.getid3/getid3.php');

// Set the folder path to scan
$folder_path = '.';

// Set the cache file name
$cache_file = 'filejson.json';

// Check if the cache file exists and load its contents
if (file_exists($cache_file)) {
    $cache = json_decode(file_get_contents($cache_file), true);
} else {
    $cache = array();
}

// Create a new instance of getID3
$getid3 = new getID3();

// Recursive function to scan the folder
function scan_folder($folder_path, &$cache, $getid3) {
    $files = scandir($folder_path);
    foreach ($files as $file) {
        if (substr($file, 0, 1) === '.') {
            continue;
        }
        $full_path = $folder_path . '/' . $file;
        if (is_dir($full_path)) {
            scan_folder($full_path, $cache, $getid3);
        } else {
            $rel_path = substr($full_path, strlen($_SERVER['DOCUMENT_ROOT']));
            if (isset($cache[$rel_path]) && filemtime($full_path) == $cache[$rel_path]['modified']) {
                continue;
            }
            $cache[$rel_path] = array(
                'modified' => filemtime($full_path),
            );
            if (preg_match('/\.(mp3|wav|ogg|flac|mp4|mov|avi|mkv)$/', $file)) {
                $file_info = $getid3->analyze($full_path);
                getid3_lib::CopyTagsToComments($file_info);
                if (isset($file_info['comments'])) {
                    $comments = $file_info['comments'];
                    $cache[$rel_path]['title'] = $comments['title'][0] ?? ucwords(str_replace('_', ' ', basename($full_path, '.' . pathinfo($full_path, PATHINFO_EXTENSION))));
                    $cache[$rel_path]['album'] = $comments['album'][0] ?? ucwords(basename(dirname($full_path)));
                    $cache[$rel_path]['artist'] = $comments['artist'][0] ?? 'Dale Blackwood';
                    $cache[$rel_path]['year'] = $comments['year'][0] ?? date('Y', filemtime($full_path));
                } else {
                    $cache[$rel_path]['title'] = ucwords(str_replace('_', ' ', basename($full_path, '.' . pathinfo($full_path, PATHINFO_EXTENSION))));
                    $cache[$rel_path]['album'] = ucwords(basename(dirname($full_path)));
                    $cache[$rel_path]['artist'] = 'Dale Blackwood';
                    $cache[$rel_path]['year'] = date('Y', filemtime($full_path));
                }
            }
        }
    }
}

scan_folder($folder_path, $cache, $getid3);

// Save the updated cache file
file_put_contents($cache_file, json_encode($cache));

// Output the JSON data
echo json_encode($cache);
