<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

require_once('.getid3/getid3.php');

function getFiles($path, $cache_file) {
    $files = array();
    $cache = array();
    if (file_exists($cache_file)) {
        $cache = json_decode(file_get_contents($cache_file), true);
    }
    foreach (scandir($path) as $file) {
        if ($file == '.' || $file == '..') {
            continue;
        }
        $file_path = $path . DIRECTORY_SEPARATOR . $file;
        if (is_dir($file_path)) {
            $files = array_merge($files, getFiles($file_path, $cache_file));
        } else {
            $file_type = pathinfo($file_path, PATHINFO_EXTENSION);
            if (in_array($file_type, array('mp3', 'ogg', 'mp4', 'avi', 'wmv', 'mov'))) {
                if (isset($cache[$file_path])) {
                    $title = $cache[$file_path]['title'];
                    $artist = $cache[$file_path]['artist'];
                    $album = $cache[$file_path]['album'];
                    $year = $cache[$file_path]['year'];
                } else {
                    $getID3 = new getID3;
                    $file_info = $getID3->analyze($file_path);
                    getid3_lib::CopyTagsToComments($file_info);
                    if (in_array($file_type, array('mp3', 'ogg'))) {
                        $title = isset($file_info['comments']['title'][0]) ? $file_info['comments']['title'][0] : '';
                        $artist = isset($file_info['comments']['artist'][0]) ? $file_info['comments']['artist'][0] : '';
                        $album = isset($file_info['comments']['album'][0]) ? $file_info['comments']['album'][0] : '';
                        $year = isset($file_info['comments']['year'][0]) ? $file_info['comments']['year'][0] : '';
                    } else {
                        $title = isset($file_info['tags']['quicktime']['title'][0]) ? $file_info['tags']['quicktime']['title'][0] : '';
                        $artist = isset($file_info['tags']['quicktime']['artist'][0]) ? $file_info['tags']['quicktime']['artist'][0] : '';
                        $album = isset($file_info['tags']['quicktime']['album'][0]) ? $file_info['tags']['quicktime']['album'][0] : '';
                        $year = isset($file_info['tags']['quicktime']['year'][0]) ? $file_info['tags']['quicktime']['year'][0] : '';
                    }
                    // If title is empty, set it to a title-cased version of the filename without extension
                    if (empty($title)) {
                        $title = ucwords(strtolower(pathinfo($file_path, PATHINFO_FILENAME)));
                    }

                    // If album is empty, set it to a title-cased version of the parent folder name
                    if (empty($album)) {
                        $album = ucwords(strtolower(basename(dirname($file_path))));
                    }

                    // If artist is empty, set it to "Dale Blackwood"
                    if (empty($artist)) {
                        $artist = "Dale Blackwood";
                    }

                    if (empty($year)) {
                        $year = date('Y', $file_info->getMTime());
                    }
                    
                    $cache[$file_path] = array(
                        'title' => $title,
                        'artist' => $artist,
                        'album' => $album,
                        'year' => $year,
                    );
                    file_put_contents($cache_file, json_encode($cache));
                }
            } else {
                $title = '';
                $artist = '';
                $album = '';
                $year = '';
            }
            $files[] = array(
                'path' => $file_path,
                'modified' => filemtime($file_path),
                'title' => $title,
                'artist' => $artist,
                'album' => $album,
                'year' => $year,
            );
        }
    }
    return $files;
}

$folder_path = '.';
$cache_file = 'file.json';
try {
    $files = getFiles($folder_path, $cache_file);
    header('Content-Type: application/json');
    echo json_encode($files);
}
catch (exception $e) {
    print($e);
}
?>