<?php

require_once('_getid3/getid3.php');

$folder_path = '.';
$cache_file = 'cache.json';

if (file_exists($cache_file)){
    $cache = json_decode(file_get_contents($cache_file), true);
} else {
    $cache = array();
}

$VIDEO_EXTS = array('mp4', 'mov', 'avi', 'mkv');
$SOUND_EXTS = array('mp3', 'wav', 'ogg', 'flac', 'm4a');
$MEDIA_EXTS = array_merge($VIDEO_EXTS, $SOUND_EXTS);
$IMAGE_EXTS = array('jpg', 'gif', 'svg', 'png');
$TEXT_EXTS = array('txt', 'json');
$ALL_EXTS = array_merge($MEDIA_EXTS, $IMAGE_EXTS, $TEXT_EXTS);

$getid3 = new getID3();

function has_extension($file, $extensions) {
    if ($file == null || empty($file))
        return false;
    $file_type = strtolower(pathinfo($file_path, PATHINFO_EXTENSION));
    return in_array($file_type, $extensions);
}

function scan_folder($folder_path, &$cache, $getid3) {
    $files = scandir($folder_path);
    foreach ($files as $file) {
        if (substr($file, 0, 1) === '.')
            continue;

        $full_path = $folder_path . '/' . $file;
        if (is_dir($full_path)) {
            scan_folder($full_path, $cache, $getid3);
            continue;
        }

        if (has_extension($file, $ALL_EXTS) === false)
            continue;

        $rel_path = substr($full_path, 2);
        if (isset($cache[$rel_path]) && filemtime($full_path) == $cache[$rel_path]['modified'])
            continue;

        $cache[$rel_path] = array(
            'modified' => filemtime($full_path), 
            'path' => $rel_path
        );
        if (has_extension($rel_path, $SOUND_EXTS)) {
            $file_info = $getid3->analyze($full_path);
            getid3_lib::CopyTagsToComments($file_info);
            if (isset($file_info['comments'])) {
                $comments = $file_info['comments'];
                $cache[$rel_path]['title'] = $comments['title'][0];
                $cache[$rel_path]['album'] = $comments['album'][0];
                $cache[$rel_path]['artist'] = $comments['artist'][0];
                $cache[$rel_path]['year'] = $comments['year'][0];
            }
        }
    }
}

function title_case($string) {
    $string = str_replace('_', ' ', $string); // replace underscores with spaces
    $string = preg_replace('/\s+/', ' ', $string); // remove double spaces
    $string = ucwords(strtolower($string)); // capitalize each word
    return $string;
}

scan_folder($folder_path, $cache, $getid3);

file_put_contents($cache_file, json_encode($cache));

$output = array();
foreach ($cache as $file) {
    $output[] = $file;
}

header('Content-Type: application/json');
echo json_encode($output);

?>