import SwiftUI

class TextFile {
    
    let forResource: String;
    let ofType: String;
    var hasLoaded = false
    var contents: String? = nil
    
    init(forResource: String, ofType: String) {
        self.forResource = forResource
        self.ofType = ofType
    }
    
    func get() -> String? {
        if (hasLoaded == false) {
            if let path = Bundle.main.path(forResource: forResource, ofType: ofType) {
                do {
                    contents = try String(contentsOfFile: path)
                } catch {
                    contents = nil
                }
            }
            hasLoaded = true
        }
        return contents;
    }
    
}
