class MutableSet<T> {
    
    var values: [T] = []
    
    func add(_ value: T) {
        if (has(value)) {
            return
        }
        values.append(value)
    }
    
    func remove(_ value: T) {
        let index = indexOf(value)
        if (index < 0) {
            return
        }
        values.remove(at: index)
    }
    
    func has(_ value: T) -> Bool {
        return indexOf(value) >= 0
    }
    
    private func indexOf(_ value: T) -> Int {
        if values.count > 0 {
            let limit = values.count - 1
            for i in 0...limit {
                if ((values[i] as AnyObject) === (value as AnyObject)) {
                    return i
                }
            }
        }
        return -1
    }
}
