import UIKit

class MainView: UITabBarController, DreadRouteListener, DreadAuthListener {
    
    var route: String = Routes.HOME_URL
    var username: String = ""
    
    var tabs: [DreadLink] = [
        Links.LINK_HOME,
        Links.LINK_CHANNELS,
        Links.LINK_CREATE_POST,
        Links.LINK_INBOX,
        Links.LINK_PROFILE
    ]
    
    override func viewDidLoad() {
        super.viewDidLoad()
        var views: [UIViewController] = []
        for var tab in tabs {
            let view = DreadView(tab.frame)
            view.tabBarItem = UITabBarItem(
                title: tab.name,
                image: UIImage(systemName: tab.icon),
                tag: tab.frame.rawValue
            )
            tab.view = view.tabBarItem
            views.append(view)
        }
        setViewControllers(views, animated: false)
        onRouteChange(DreadService.instance().route)
        onSessionChange(DreadService.instance().session)
        selectedIndex = 0
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        DreadService.instance().authListeners.add(self)
        DreadService.instance().routeListeners.add(self)
    }
    
    override func viewDidDisappear(_ animated: Bool) {
        super.viewDidDisappear(animated)
        DreadService.instance().authListeners.remove(self)
        DreadService.instance().routeListeners.remove(self)
    }
     
    func onRouteChange(_ routeInfo: DreadRoute) {
        route = routeInfo.toString()
        selectedIndex = routeInfo.frame.rawValue
        for var tab in tabs {
            let tabRoute = DreadService.instance().getFrameRoute(tab.frame)
            tab.enabled =
        }
    }
    
    func onSessionChange(_ session: Session) {
        tabs[1] = session.isAuthed() ? Links.LINK_CHANNELS_MINE : Links.LINK_CHANNELS
        let newUsername = session.username
        if (newUsername != username) {
            username = newUsername
        }
    }
    
}
