import "./chunk-IVLCYF2H.js";

// node_modules/observational/hooks/hooklib.js
var _lib = void 0;
var requredHooks = [
  "useState",
  "useEffect"
];
function initHooks(hooksLibrary) {
  if (!hooksLibrary) {
    throw new Error("hooks library must be defined");
  }
  for (const key of requredHooks) {
    if (hooksLibrary.hasOwnProperty(key) === false) {
      throw new Error("hooks library must have " + key + " hook");
    }
  }
  if (typeof hooksLibrary.useEffect !== "function") {
    throw new Error("hooks library must have useEffect hook");
  }
  _lib = hooksLibrary || void 0;
}
function requireLib() {
  if (!_lib) {
    throw new Error(`Observational hooks library not initialised.            To call the library from you application's init file            Use:            import { initHooks } from "observational\\hooks";            import { useState, useEffect } from "react";            initHooks({ useState, useEffect });`);
  }
  return _lib;
}

// node_modules/observational/hooks/useSubject.js
function useSubject(subject, onMount, onUnmount) {
  const lib = requireLib();
  const [value, onValueChange] = lib.useState(subject.value);
  const scope = {};
  let isMounted = false;
  let isDirty = false;
  const handleValueChange = (value2) => {
    isDirty = true;
    if (isMounted === false)
      return;
    isDirty = false;
    onValueChange(value2);
  };
  lib.useEffect(() => {
    subject.listen(scope, handleValueChange, { immediate: false });
    if (onMount)
      onMount();
    isMounted = true;
    if (isDirty) {
      handleValueChange(subject.value);
    }
    return function cleanup() {
      subject.unlisten(scope, handleValueChange);
      if (onUnmount)
        onUnmount();
    };
  }, []);
  return [value, subject.setValue.bind(subject)];
}
export {
  initHooks,
  requireLib,
  useSubject
};
//# sourceMappingURL=observational_hooks.js.map
