class_name SceneUtils

static func find_children(parent: Node, node_type: Variant, results: Array[Node] = []) -> Array[Node]:
	if is_instance_of(parent, node_type):
		results.append(parent)
	for child in parent.get_children():
		find_children(child, node_type, results)
	return results
	
static func find_child(parent: Node, node_type: Variant) -> Variant:
	if is_instance_of(parent, node_type):
		return parent
	for child in parent.get_children():
		var child_match = find_child(child, node_type)
		if child_match:
			return child_match
	return null
		
