extends Node

func fire(fx_child_name: String, position: Vector3) -> Node:
	var instance = find_child(fx_child_name)
	if not instance:
		return null
	if is_instance_of(instance, FXPool):
		instance = instance.next()
	if is_instance_of(instance, Node3D):
		instance.global_transform.origin = position
	if instance.has_method("fire"):
		instance.fire()
	return instance
