class_name FXPool
extends Node

@export var scene: PackedScene
@export var instance_count = 10

var instances: Array[Node]
var index = 0

func next() -> Node: 
	index = (index + 1) % instance_count
	if not instances:
		instances = []
		instances.resize(instance_count)
	if instances[index] == null:
		instances[index] = scene.instantiate()
		add_child(instances[index])
	return instances[index]
	
	
func peek() -> Node:
	if not instances:
		return null
	return instances[index]
		
