class_name Behaviour

enum Status { Init, Running, Ended }

var time := 0.0
var delta := 0.0
var behaviour: Behaviour = null
var status := Status.Init

func update(_delta: float) -> void:
	delta = _delta
	time += _delta
	if behaviour:
		if behaviour.status < Status.Ended:
			if behaviour.status < Status.Running:
				behaviour.time = 0.0
				behaviour.status = Status.Running
				behaviour.on_enter()
			behaviour.update(delta)
		if behaviour.status > Status.Running:
			behaviour = null
	if not behaviour:
		set_behaviour(pick())
	on_update()
	
func set_behaviour(new_behaviour: Behaviour) -> void:
	if behaviour and behaviour.status < Status.Ended:
		behaviour.on_exit()
	behaviour = new_behaviour

func on_enter() -> void:
	pass
	
func on_update() -> void:
	pass
	
func on_exit() -> void:
	pass
	
func pick() -> Behaviour:
	return null
	
