extends RigidBody3D

var init_mask: int = 1
var init_layer: int = 1
var init_basis: Basis
var fire_time = 0.0
var off_time = 0.0
var is_projectile = false
var evap_rate = 1.0


func _init() -> void:
	init_mask = collision_mask
	init_layer = collision_layer
	init_basis = transform.basis
	body_entered.connect(_on_body_entered)
	

func fire() -> void:
	set_projectile(true)
	
	
func set_projectile(on: bool) -> void:
	if not on and fire_time < 0.1:
		return
		
	if on == is_projectile:
		return
		
	is_projectile = on
	collision_mask = init_mask if on else 0
	collision_layer = init_layer if on else 0
	transform.basis = init_basis if on else Basis.from_scale(Vector3(3.0, 0.1, 3.0))
	freeze = not on
	if on:
		fire_time = 0.0
	else:
		off_time = 0.0
		evap_rate = randf_range(0.4, 0.8)
		linear_velocity = Vector3.ZERO
		global_transform.origin.y = 0.01


func _process(delta: float) -> void:
	if is_projectile:
		fire_time += delta
	else:
		off_time += delta
		var s = maxf(0.0, 6.0 - off_time * evap_rate)
		transform.basis = Basis.from_scale(Vector3(s, 0.1, s))


func _on_body_entered(_body: Node):
	set_projectile(false)
