class_name Actor
extends CharacterBody3D

enum Faction {
	Good,
	Evil,
	Any
}

var faction := Faction.Good
var stage: Stage
var position_feet: Vector3:
	get: return global_transform.origin
var position_head: Vector3:
	get: return global_transform.origin + Vector3(0, 0.5, 0)

func _enter_tree():
	stage = get_tree().current_scene as Stage
	if stage:
		stage.register(self)
	
	
func _exit_tree():
	if stage:
		stage.unregister(self)
		
		
func can_see_position(position: Vector3) -> bool:
	var space = get_world_3d().direct_space_state
	var ray = PhysicsRayQueryParameters3D.create(position_head, position)
	var result = space.intersect_ray(ray)
	return result.has("collider")
	
	
func can_see(node: Node3D) -> bool:
	if is_instance_of(node, Actor):
		return can_see_position(node.position_head)
	return can_see_position(node.global_transform.origin)
