class_name PlayerLook
extends Camera3D

var MAX_LOOK_ANGLE = PI * 0.5
var MULTIPLIER_H = 3.5
var MULTIPLIER_V = 2.0
var look_delta = Vector2.ZERO


func _ready() -> void:
	Input.mouse_mode = Input.MOUSE_MODE_CAPTURED
	look_delta = Vector2.ZERO
	

func _process(delta: float) -> void:
	var parent = get_parent_node_3d()
	var look_angles = parent.transform.basis.get_euler()
	look_angles.y -= look_delta.x * MULTIPLIER_H
	look_angles.x += look_delta.y * MULTIPLIER_V
	look_angles.x = clampf(look_angles.x, -MAX_LOOK_ANGLE, MAX_LOOK_ANGLE)
	parent.transform.basis = Basis().from_euler(look_angles)
	look_delta = Vector2.ZERO


func _input(e: InputEvent) -> void:
	if e is InputEventMouseMotion:
		look_delta += e.relative / get_viewport().size.x
