class_name PlayerHand
extends Node3D

@export var offset := Vector3(-0.1, -0.2, 0.15)
var head: Node3D
var phase := 0.0
var last_pos := Vector3.ZERO
var weapon: Weapon


func _ready() -> void:
	head = get_node("../Head")
	set_weapon(get_node("Bottle"))
	
	
func _process(delta: float) -> void:
	var head_t = head.global_transform
	var head_angles = head_t.basis.get_euler()
	var angles = head_angles
	angles.x *= 0.5
	angles.z *= 0.5
	var rot = Quaternion.from_euler(angles)
	rot *= Quaternion(Vector3.RIGHT, PI * -0.05)
	global_transform.basis = Basis(rot)
	var pos = head_t.origin + rot * offset
	var p_pos = head_t.origin
	var diff = last_pos - p_pos
	if diff.length_squared() > delta * delta:
		phase += delta * 10.0
	pos.y += sin(phase) * 0.05
	global_transform.origin = pos
	last_pos = p_pos
	
	
func set_weapon(new_weapon: Node) -> void:
	if is_instance_of(weapon, Weapon):
		weapon.set_holding(false)
		weapon.queue_free()
	weapon = new_weapon
	if is_instance_of(weapon, Weapon):
		weapon.set_holding(true)
		if weapon.get_parent() != self:
			add_child(weapon)
	
	
func fire() -> void:
	if weapon:
		weapon.fire()
