class_name Player
extends Actor

var look_node: Node3D
var body: Node3D
var travel_pc = 0.0
var travel_src = Vector3.ZERO
var travel_dest = Vector3.ZERO
enum State { FREE, TRAVEL }
var state = State.FREE
var crawl_area: CrawlArea = null
var hand: PlayerHand
var fire_timer = 0.0


func _init():
	faction = Faction.Good


func _ready():
	look_node = get_node("Head/Cam")
	body = get_node("Body")
	crawl_area = stage.find_area_nearest(global_transform.origin)
	global_transform.origin = crawl_area.global_transform.origin
	hand = get_node("Hand")
	

func _physics_process(delta: float) -> void:
	match state:
		State.TRAVEL:
			return update_travel(delta)
	return update_free(delta)
	

func update_free(delta: float) -> void:
	var input = Vector2(
		Input.get_axis("move_left", "move_right"),
		Input.get_axis("move_backward", "move_forward")
	)
	var right = look_node.global_transform.basis.x
	var forward = right.cross(Vector3.UP)
	velocity = right * input.x - forward * input.y
	move_and_slide()
	update_firing(delta)
	if crawl_area and not crawl_area.contains(global_transform.origin):
		var next_area = stage.find_jump_area(global_transform.origin, look_node.global_transform.basis.z)
		if next_area:
			set_area(next_area)
			
			
func update_firing(delta: float) -> void:
	if Input.is_action_pressed("fire"):
		var fire_rate = 1.0 if not hand.weapon else hand.weapon.fire_rate
		fire_timer += delta
		while fire_timer > 0.0:
			hand.fire()
			fire_timer -= fire_rate
		fire_timer = fmod(fire_timer, fire_rate)
	
	
func update_travel(delta: float) -> void:
	var dist = (travel_dest - travel_src).length()
	var travel_time = dist
	var pos = travel_src.lerp(travel_dest, travel_pc)
	pos.y = sin(travel_pc * PI)
	travel_pc += delta
	if travel_pc >= 1.0:
		travel_pc = 1.0
		state = State.FREE
	velocity = (pos - global_transform.origin) / delta
	move_and_slide()
	
	
func set_area(next_area: CrawlArea) -> void:
	crawl_area = next_area
	travel(crawl_area.global_transform.origin)

	
func travel(position: Vector3) -> void:
	if state == State.TRAVEL:
		return
	travel_src = global_transform.origin
	travel_dest = position
	travel_pc = 0.0
	state = State.TRAVEL
	

func get_forward() -> Vector3:
	return body.global_transform.basis.z
