#include "../engine/Hash.h"
#include <stdio.h>

template <class T>
class Ref
{
protected:
    T * instance;
    HashInt hash;

    static int GetNextHash()
    {
        static int hash = 1;
        return hash++;
    }

public:
    Ref(T * instance = NULL, int hash = 0) : instance(instance), hash(hash) 
    {
        if (hash == 0 && instance != NULL)
        {
            hash = GetNextHash();
        }
    }

    inline T * Inst() const { return instance; }
    inline const HashInt Hash() const { return hash; }

    int operator==(T * x) { return x == instance ? 1 : 0; }
    int operator!=(T * x) { return x != instance ? 1 : 0; }
    int operator==(Ref<T> & x) { return x != NULL && x->instance == instance ? 1 : 0; }
    int operator!=(Ref<T> & x) { return x != NULL && x->instance != instance ? 1 : 0; }
};

class A
{
public:
    int value = 0;
};

Ref<A> & GetA()
{
    static A a;
    static Ref<A> refA(&a);
    return refA;
}

int main(int argc, char * argv[])
{
    Ref<A> refA = GetA();
    Ref<A> refB = GetA();
    refA.Inst()->value = 1;
    refB.Inst()->value = 2;
    printf("a.value %i", refA.Inst()->value);
    printf("b.value %i", refB.Inst()->value);
    printf("a %s b", refA == refB ? "is" : "isn't");
    printf("a.value %s b.value", refA.Inst()->value == refB.Inst()->value ? "is" : "isn't");
} 