from xml.etree import ElementTree
from argparse import ArgumentParser
import os
from pathlib import Path

def rescale_att(obj, att, scale):
    obj.attrib[att] = str(int(float(obj.attrib[att]) * scale))

def process_file(file_path, scale):
    tree = ElementTree.parse(file_path)
    root = tree.getroot()
    rescale_att(root, "tilewidth", scale)
    rescale_att(root, "tileheight", scale)
    objects = root.findall(".//object")
    for obj in objects:
        rescale_att(obj, "x", scale)
        rescale_att(obj, "y", scale)
        rescale_att(obj, "width", scale)
        rescale_att(obj, "height", scale)
    out_dir = os.path.join(os.path.dirname(file_path), "output")
    if not os.path.exists(out_dir):
        os.mkdir(out_dir)
    out_path = os.path.join(out_dir, os.path.basename(file_path))
    tree.write(out_path)


def process_folder(folder_path, scale):
    if not os.path.exists(folder_path):
        raise "Folder path %s doesn't exist!" % folder_path

    if not os.path.isdir(folder_path):
        raise "Path is not a directory!"

    for file in Path(folder_path).glob("*.tmx"):
        process_file(os.path.join(folder_path, file.name), scale)


def main():
    parser = ArgumentParser(description = "Rescale some maps")
    parser.add_argument("folder", type=str, help="Folder to scan")
    parser.add_argument("scale", type=float, help="Scale to apply")
    args = parser.parse_args()
    process_folder(args.folder, args.scale)

main()