from xml.etree import ElementTree
from argparse import ArgumentParser
import os
from pathlib import Path


def process_file(file_path, gid_in: int, gid_out: int):
    changed = False
    tree = ElementTree.parse(file_path)
    root = tree.getroot()
    objects = root.findall(".//object")
    for obj in objects:
        gid = obj.attrib.get("gid")
        if gid == str(gid_in):
            obj.attrib["gid"] = str(gid_out)
            changed = True
    if changed == False:
        return
    out_dir = os.path.join(os.path.dirname(file_path), "output")
    if not os.path.exists(out_dir):
        os.mkdir(out_dir)
    file_name = os.path.basename(file_path)
    out_path = os.path.join(out_dir, file_name)
    tree.write(out_path)


def process_folder(folder_path, gid_in: int, gid_out: int):
    if not os.path.exists(folder_path):
        raise "Folder path %s doesn't exist!" % folder_path

    if not os.path.isdir(folder_path):
        raise "Path is not a directory!"

    for file in Path(folder_path).glob("*.tmx"):
        process_file(os.path.join(folder_path, file.name), gid_in, gid_out)


def main():
    parser = ArgumentParser(description = "Replace tile")
    parser.add_argument("folder", type=str, help="Folder to scan")
    parser.add_argument("gid_in", type=int, help="in guid")
    parser.add_argument("gid_out", type=int, help="out guid")
    args = parser.parse_args()
    process_folder(args.folder, args.gid_in, args.gid_out)

main()