from xml.etree import ElementTree
from argparse import ArgumentParser
import os
from pathlib import Path

map_replaces = {
    "v1": "",
    "v2": ""
}

def rename(s: str):
    for k,v in map_replaces.items():
        if s.startswith(k):
            s = s.replace(k,v)
            break
    return s


def rename_map_att(obj: ElementTree.Element, att: str):
    if obj.attrib.get("name"):
        obj.attrib["name"] = rename(obj.attrib["name"])


def process_file(file_path):
    tree = ElementTree.parse(file_path)
    root = tree.getroot()
    objects = root.findall(".//object")
    for obj in objects:
        rename_map_att(obj, "name")
    out_dir = os.path.join(os.path.dirname(file_path), "output")
    if not os.path.exists(out_dir):
        os.mkdir(out_dir)
    file_name = os.path.basename(file_path)
    file_name = rename(file_name)
    out_path = os.path.join(out_dir, file_name)
    tree.write(out_path)


def process_folder(folder_path):
    if not os.path.exists(folder_path):
        raise "Folder path %s doesn't exist!" % folder_path

    if not os.path.isdir(folder_path):
        raise "Path is not a directory!"

    for file in Path(folder_path).glob("*.tmx"):
        process_file(os.path.join(folder_path, file.name))


def main():
    parser = ArgumentParser(description = "Rescale some maps")
    parser.add_argument("folder", type=str, help="Folder to scan")
    args = parser.parse_args()
    process_folder(args.folder)

main()