from xml.etree import ElementTree
from argparse import ArgumentParser
import os
from pathlib import Path

def rename_map_att(obj: ElementTree.Element, att: str):
    layer = obj.attrib.get("name")
    if layer.startswith("layer"):
        layern = int(layer[5:])
        layer = layer + str(layern)
    return layer


def process_file(file_path):
    tree = ElementTree.parse(file_path)
    root = tree.getroot()
    props = root.findall(".//property")
    for prop in props:
        rename_map_att(prop, "name")
    out_dir = os.path.join(os.path.dirname(file_path), "output")
    if not os.path.exists(out_dir):
        os.mkdir(out_dir)
    out_path = os.path.join(out_dir, os.path.basename(file_path))
    tree.write(out_path)


def process_folder(folder_path):
    if not os.path.exists(folder_path):
        raise "Folder path %s doesn't exist!" % folder_path

    if not os.path.isdir(folder_path):
        raise "Path is not a directory!"

    for file in Path(folder_path).glob("*.tmx"):
        process_file(os.path.join(folder_path, file.name))


def main():
    parser = ArgumentParser(description = "Rescale some maps")
    parser.add_argument("folder", type=str, help="Folder to scan")
    args = parser.parse_args()
    process_folder(args.folder)

main()