workspace "dess"
    configurations { "Debug", "Release" }

project "game_test"
    includedirs { "game_test" }
    files { "game_test/**.cpp" }

project "game_sword"
    includedirs { "game_sword" }
    files { "game_sword/**.cpp" }

project "music_test"
    includedirs { "music_test" }
    files { "music_test/**.cpp" }

project "*"
    kind "ConsoleApp"
    language "C++"
    cppdialect "C++11"
    architecture ("x86_64")
    targetdir ("bin")
    links { "SDL2main", "SDL2", "SDL2_image", "libmodplug", "SDL2_mixer", "glew32", "opengl32", "glu32" }
    libdirs { "lib" }
    includedirs { "include", "engine", "engine/3rdparty" }

    files { "engine/**.cpp" }

    filter "configurations:Debug"
        defines { "DEBUG" }
        symbols "On"

    filter "configurations:Release"
        kind "WindowedApp"
        defines { "NDEBUG" }
        optimize "Off"

workspace "*"