#include <desslibs.h>
#include <libmodplug.h>

struct ModMusicCue
{
    u16 start = 0;
    u16 end = 0;
    u16 repeat = 0;
    u16 bpm = 170;
    bool persistant = false;
};

ModPlugFile * mod = NULL;
u32 position = 0;
SDL_AudioDeviceID device;
SDL_AudioSpec audioSpec;
void * modBuffer;

ModMusicCue currentCue;

void OnAudioRequest2(void * userdata, u8 * stream, int len)
{
    u32 startOrder = ModPlug_GetCurrentOrder(mod);
    u32 startBeat = ModPlug_GetCurrentRow(mod);
    u32 startPattern = ModPlug_GetCurrentPattern(mod);
    u32 bytesRead = ModPlug_Read(mod, stream, len);
    position += bytesRead;
    u32 endOrder = ModPlug_GetCurrentOrder(mod);
    if (endOrder > currentCue.end)
    {
        u32 endRow = ModPlug_GetCurrentRow(mod);
        u32 samplesPerRow = audioSpec.freq * 60 / ModPlug_GetCurrentTempo(mod) / 2;
        u32 beatOffset = position % (samplesPerRow * 2);
        int overflow = (endRow * samplesPerRow + beatOffset);
        u8 * writepos = stream + (len - overflow - 1);
        ModPlug_SeekOrder(mod, currentCue.repeat);
        position = ModPlug_Read(mod, writepos, overflow);
        //memset(writepos, 0, overflow);
    }
}

void OnAudioRequest(void * userdata, u8 * stream, int len)
{
    int bytesRead = ModPlug_Read(mod, stream, len);
    position += bytesRead;
    int pattern = ModPlug_GetCurrentOrder(mod);
    if (currentCue.end > 0 && pattern > currentCue.end)
    {
        int beat = ModPlug_GetCurrentRow(mod);
        u32 samplesPerBeat = audioSpec.freq * 60 / ModPlug_GetCurrentTempo(mod);
        u32 bytesPerBeat = samplesPerBeat * audioSpec.channels / 2;
        u32 bytesOver = (position % bytesPerBeat) + (beat) * bytesPerBeat;
        u32 writeIndex = len - bytesOver;
        u16 repeat = currentCue.repeat == 0 ? currentCue.start : currentCue.repeat;
        ModPlug_SeekOrder(mod, repeat);
        position = ModPlug_Read(mod, stream + writeIndex, len - writeIndex);    
    }
}

int RunAsSlave()
{
    SDL_AudioSpec request;
    request.freq = 44100;
    request.channels = 2;
    request.format = AUDIO_S16SYS;
    request.callback = &OnAudioRequest;
    device = SDL_OpenAudioDevice(NULL, 0, &request, &audioSpec, 0);
    
    modBuffer = malloc(audioSpec.samples);
	ModPlug_SetMasterVolume(mod, 512);
    SDL_PauseAudioDevice(device, 0);
    while (true) 
    {
    }
    return 0;
}

int RunAsMaster()
{
    SDL_AudioSpec request;
    request.freq = 44100;
    request.channels = 2;
    request.format = AUDIO_S16SYS;
    request.callback = NULL;//&OnAudioRequest;
    device = SDL_OpenAudioDevice(NULL, 0, &request, &audioSpec, 0);

    u32 samplesPerBeat = audioSpec.freq / 60 / 2 * ModPlug_GetCurrentTempo(mod);
    u32 msPerBeat = ModPlug_GetCurrentTempo(mod) * 1000 / 60 / 8;

    u32 beat = 0;
    
    modBuffer = malloc(samplesPerBeat);
	ModPlug_SetMasterVolume(mod, 512);
    SDL_PauseAudioDevice(device, 0);
    while (true) 
    {
        ModPlug_Read(mod, modBuffer, samplesPerBeat);
        SDL_QueueAudio(device, modBuffer, samplesPerBeat);
        SDL_Delay(msPerBeat);
        beat++;
        printf("beat %i\n", beat);
        if (beat >= 16)
        {
            ModPlug_SeekOrder(mod, 4);
            beat = 0;
        }
    }
    return 0;
}

int main( int argc, char * argv[] ) 
{
    const char * path = "data/music.it";
    if (argc == 2) 
    {
        path = argv[1];
    }

    if (SDL_Init(SDL_INIT_AUDIO) != 0)
    {
        printf("Audio failed %s\n", SDL_GetError());
        return 1;
    }
    
    SDL_RWops * rw = SDL_RWFromFile(path, "rb");
	if (rw == NULL) 
	{
		printf("File cannot be read: %s\n", path);
		return 1;
	}
    u32 fileSize = SDL_RWsize(rw);
    void * fileBuffer = malloc(fileSize);
    SDL_RWread(rw, fileBuffer, fileSize, 1);
    SDL_RWclose(rw);

    currentCue.start = 20;
    currentCue.end = 20;

    mod = ModPlug_Load(fileBuffer, fileSize);
    ModPlug_SeekOrder(mod, currentCue.start);

    return RunAsSlave();
}