#include <desslibs.h>
#include <Game.h>
#include <Input.h>
#include <TestSceneModel.h>
#include <TestSceneText.h>
#include <TestBones.h>
#include <TestMusic.h>
#include <RenderWindow.h>

int main(int argc, char *argv[]) 
{
	Game game("DESS Game Demo");
	TestSceneModel scene;
	Scene* scenes[] = {
		new TestMusicScene(),
		new TestBonesScene(),
		new TestSceneText(),
		new TestSceneModel()
	};
	u16 currentSceneIndex = UINT8_MAX;
	u16 nextSceneIndex = 0;
	u16 sceneCount = sizeof(scenes) / sizeof(Scene*);
	//RenderWindow::Current()->SetDisplayMode(DisplayMode_Modern);

	while (game.Tick())
	{
		if (nextSceneIndex != currentSceneIndex)
		{
			currentSceneIndex = nextSceneIndex;
			game.SetScene(scenes[currentSceneIndex]);
		}
		if (Input::WasKeyPressed(SDL_SCANCODE_Q))
		{
			nextSceneIndex = currentSceneIndex == 0 ? sceneCount - 1 : currentSceneIndex - 1;
		}
		if (Input::WasKeyPressed(SDL_SCANCODE_W))
		{
			nextSceneIndex = currentSceneIndex == sceneCount - 1 ? 0 : currentSceneIndex + 1;
		}
		continue;
	}

	return 0;
}