#include <desslibs.h>
#include <Camera.h>
#include <RenderWindow.h>
#include <TestTriangle.h>

// An array of 3 vectors which represents 3 vertices
static const GLfloat TRIANGLE_VERTS[] = {
   -1.0f, -1.0f, 0.0f,
   1.0f, -1.0f, 0.0f,
   0.0f,  1.0f, 0.0f,
};

static float angle = 0.0f;

void TestTriangle::Update(float dt)
{
	angle += dt * 100.0f;
	Camera * cam = Camera::Current();
	float rad = angle * DEG2RAD;
	cam->transform.SetPosition(Vector3(
		cosf(rad) * 4.0f,
		3.0f,
		sinf(rad) * 4.0f
	));
	RenderWindow::Current()->RenderData(
		TRIANGLE_VERTS, sizeof(TRIANGLE_VERTS) / sizeof(GLfloat)
	);
}