#ifndef _TEST_SCENE_MODEL_H
#define _TEST_SCENE_MODEL_H

#include <Scene.h>
#include <Camera.h>
#include <TestMd2Model.h>
#include <TestModel.h>
#include <Input.h>

class TestSceneModel : public Scene
{
private:
	Camera camera;
	TestModel test1;
	TestMd2Model test2;
	float angle;
	float time;

public:
	void Init()
	{
		test1.transform.position.x = -1.0f;
		test2.transform.position.x = 1.0f;
		angle = 0.0f;
		time = 0.0f;
		camera.SetCurrent();

		AddEntity(&test1);
		AddEntity(&test2);
	}

	void Update(float dt)
	{
		time += dt;
		Scene::Update(dt);

		float camRotateDir = 0.0f;
		if (Input::IsKeyHeld('a'))
		{
			camRotateDir -= 1.0f;
		}
		if (Input::IsKeyHeld('d'))
		{
			camRotateDir += 1.0f;
		}

		angle += dt * 100.0f * camRotateDir;

		float rad = angle * DEG2RAD;
		float dist = 8.0f;
		camera.transform
			.SetPosition(Vector3(
				cosf(rad) * dist,
				2.0f,
				sinf(rad) * -dist
			))
			.LookAt(Vector3(0, 0, 0));

		test1.transform.position.y = sinf(time * DEG2RAD * 10.0f) * 2.0f;
		test2.transform.Rotate(Vector3_UP, dt);
	}
};

#endif