#ifndef _TEST_MD2_MODEL_H
#define _TEST_MD2_MODEL_H

#include <Entity.h>
#include <read/md2/Md2Reader.h>
#include <MeshRenderer.h>
#include <Model3D.h>
#include <Input.h>

class TestMd2Model : public Entity
{
private:
    Model3D model;
    ModelAnimData * animRun = NULL;

public:
    void Start()
    {
        model.LoadModel("data/lynn3.md2", 0.24f);
        model.SetMaterial("data/lynn.bmp");
        animRun = model.FindAnimation("run");
        model.fps = 60.0f;
    }

    void Update(float dt)
    {
        if (Input::WasKeyPressed('w'))
        {
            if (RenderWindow::Current()->GetRenderMode() == RenderMode_Standard)
            {
                RenderWindow::Current()->SetRenderMode(RenderMode_Wireframe);
            }
            else
            {
                RenderWindow::Current()->SetRenderMode(RenderMode_Standard);
            }
        }
        if (Input::WasKeyPressed('p'))
        {
            model.PlayAnimation(animRun);
        }
        model.Update(dt);
    }

    void Render()
    {
        model.Render(transform.GetMatrix());
    }
};

#endif