#ifndef _TEST_IQM_H
#define _TEST_IQM_H

#include <Entity.h>
#include <Mesh.h>
#include <MeshRenderer.h>
#include <Material.h>
#include <read/iqm/IqmReader.h>
#include <Scene.h>

class TestIqm : public Entity
{
private:
    Mesh mesh;
    Material material;
    MeshRenderer renderer;
    IqmReader reader;
    ModelBoneData * boneArmL = NULL;
    ModelAnimData * animRun = NULL;
    float time = 0.0f;

public:
    void Start()
    {
        reader.Load("data/blacksmith.iqm");
        reader.fps = 10.0f;
        material.LoadTexture("data/blacksmith.png", "shaders/standard");
        mesh.SetMaterial(&material);
        animRun = reader.FindAnimation("run");
        boneArmL = reader.FindBone("B_Arm.L");
        reader.SetAnimation(animRun);
    }

    void Update(float dt)
    {
        time += dt;
        reader.Process(&mesh, &time);
    }

    void Render()
    {
        renderer.Render(&mesh, transform.GetMatrix());
    }
};

class TestIqmScene : public Scene
{
private:
    TestIqm model;
	Camera camera;
    float angle = 0.0f;

public:

    void Init()
    {
        AddEntity(&model);
		camera.SetCurrent();
    }

    void Update(float dt)
    {
        Scene::Update(dt);

        float camRotateDir = 0.0f;
		if (Input::IsKeyHeld('a'))
		{
			camRotateDir -= 1.0f;
		}
		if (Input::IsKeyHeld('d'))
		{
			camRotateDir += 1.0f;
		}

		angle += dt * 100.0f * camRotateDir;

		float rad = angle * DEG2RAD;
		float dist = 18.0f;
		camera.transform
			.SetPosition(Vector3(
				cosf(rad) * dist,
				2.0f,
				sinf(rad) * -dist
			))
			.LookAt(Vector3(0, 0, 0));
    }
};

#endif