#ifndef _TEST_BONES_H
#define _TEST_BONES_H

#include <Entity.h>
#include <Model3D.h>
#include <MeshRenderer.h>
#include <Scene.h>
#include <Camera.h>
#include <Input.h>
#include <Maths.h>

class TestBones : public Entity
{
private:
    Model3D modelCharacter;
    Model3D modelHolding;
    const ModelBoneData * boneHold = NULL;
    ModelAnimData * animRun = NULL;
    ModelAnimData * animIdle = NULL;
    float time = 0.0f;

public:
    void Start()
    {
        modelCharacter.fps = 10.0f;
        modelCharacter.LoadModel("models/blacksmith.iqm", 0.5f);
        modelCharacter.SetMaterial("models/blacksmith.png");
        animRun = modelCharacter.FindAnimation("run");
        animIdle = modelCharacter.FindAnimation("idle");
        animRun->loop = true;
        boneHold = modelCharacter.FindBone("B_Hand.L");
        modelCharacter.PlayAnimation(animRun);

        modelHolding.LoadModel("models/swordsword.iqm", 0.7f);
        modelHolding.SetMaterial("mats/rock.png");
    }

    void Update(float dt)
    {
        time += dt;
        modelCharacter.BlendAnimation((int)(floor(time)) % 2 == 0 ? animIdle : animRun, 0.2f, 60.0f);
        modelCharacter.Update(dt);
    }

    void Render()
    {
        Matrix mtx = transform.GetMatrix();
        modelCharacter.Render(mtx);
        mtx *= modelCharacter.GetBonePose(boneHold, false);
        mtx = glm::rotate(mtx, PI * 0.5f, Vector3_RIGHT);
        modelHolding.Render(mtx);
    }
};

class TestBonesScene : public Scene
{
private:
    TestBones model;
	Camera camera;
    float angle = 0.0f;
    bool moveMode = false;

public:

    void Init()
    {
        AddEntity(&model);
		camera.SetCurrent();
        camera.backgroundColor = Vector3(0.5f);
    }

    void Update(float dt)
    {
        Scene::Update(dt);

        float camRotateDir = 0.0f;
		if (Input::IsKeyHeld('a'))
		{
			camRotateDir -= 1.0f;
		}
		if (Input::IsKeyHeld('d'))
		{
			camRotateDir += 1.0f;
		}

		angle += dt * 30.0f * camRotateDir;

		float rad = angle * DEG2RAD + PI * -0.5f;
		float dist = 30.0f;
		camera.transform
			.SetPosition(Vector3(
				cosf(rad) * dist,
				2.0f,
				sinf(rad) * -dist
			))
			.LookAt(Vector3_ZERO);

        model.transform.Rotate(Vector3_UP, dt);

        if (Maths::IsWithinDistance(model.transform.position, 10.0f) == false)
        {
            model.transform.position = Vector3_ZERO;  
            moveMode = !moveMode;
        }
        else
        {
            if (moveMode)
            {
                model.transform.position += Vector3_NORTH * dt;
            }
            else
            {
                model.transform.position += Vector3_EAST * dt;
            }
        }
    }
};

#endif