#ifndef UI_PROGRESS_H
#define UI_PROGRESS_H

#include <Entity.h>
#include <Missions.h>
#include <Sprite.h>
#include <Textbox.h>
#include <Font.h>
#include <Material.h>
#include <RenderWindow.h>

class UIProgress : public Entity
{
private:
    Textbox txtStatus;
    Sprite spriteMissions[GameProgress_MISSION_COUNT];
    Sprite spriteCoins[GameProgress_COIN_COUNT];

public:
    bool shortMode = false;

    void Added()
    {
        txtStatus.SetFont("fonts/pixel");
        txtStatus.SetAlignment(Vector2(0.5f, 0));
        txtStatus.SetFontSize(16);
        txtStatus.Added();

        Ref<Material> & uiMat = Material::Load("mats/entities-px.png", "shaders/ui.dsh");

        for (u8 i=0; i<GameProgress_MISSION_COUNT; i++)
        {
            spriteMissions[i].Load(uiMat);
            spriteMissions[i].SetSize(32, 32);
            spriteMissions[i].SetRect((u8)5, (u8)2, (u8)8, (u8)8);
            spriteMissions[i].Added();
        }

        for (u8 i=0; i<GameProgress_COIN_COUNT; i++)
        {
            spriteCoins[i].Load(uiMat);
            spriteCoins[i].SetSize(32, 32);
            spriteCoins[i].SetRect((u8)3, (u8)4, (u8)8, (u8)8);
            spriteCoins[i].Added();
        }
        
        renderQueue = 100;
    }

    void Format2(char * out, u8 value)
    {
        u8 value1 = value / 10;
        u8 value2 = value % 10;
        out[0] = (char)(value1 + (u8)'0');
        out[1] = (char)(value2 + (u8)'0');
        out[2] = '\0';
    }

    void OnEnabled()
    {
        GameProgress progress = Missions::Inst().GetProgress();
        
        char text[64];
        u16 hours = progress.time / 3600;
        char mins[3];
        Format2(mins, (progress.time % 3600) / 60);
        char secs[3];
        Format2(secs, progress.time % 60);
        sprintf(text, "PROGRESS: %i%\nTIME: %i:%s:%s\nDEATHS: %i", progress.percent, hours, mins, secs, progress.deaths);
        txtStatus.SetText(text);

        for (u8 i=0; i<GameProgress_MISSION_COUNT; i++)
        {
            if (progress.missions[i])
            {
                spriteMissions[i].SetRect((u8)5, (u8)2, (u8)8, (u8)8);
            }
            else
            {
                spriteMissions[i].SetRect((u8)6, (u8)2, (u8)8, (u8)8);
            }
        }

        for (u8 i=0; i<GameProgress_COIN_COUNT; i++)
        {
            if (progress.coins[i])
            {
                spriteCoins[i].SetRect((u8)3, (u8)4, (u8)8, (u8)8);
            }
            else
            {
                spriteCoins[i].SetRect((u8)6, (u8)2, (u8)8, (u8)8);
            }
        }
    }

    void Render()
    {
        txtStatus.transform.position = transform.position + Vector3(64, 0, 0);
        txtStatus.Render();
        if (shortMode == false)
        {
            for (u8 i=0; i<GameProgress_MISSION_COUNT; i++)
            {
                if (spriteMissions[i].IsVisible())
                {
                    spriteMissions[i].transform.SetPosition(transform.position + Vector3(
                        i % 4 * 32, i / 4 * 32 + 84, 0
                    ));
                    spriteMissions[i].Render();
                }
            }
            for (u8 i=0; i<GameProgress_COIN_COUNT; i++)
            {
                if (spriteCoins[i].IsVisible())
                {
                    spriteCoins[i].transform.SetPosition(transform.position + Vector3(
                        i % 4 * 32, i / 4 * 32 + 180, 0
                    ));
                    spriteCoins[i].Render();
                }
            }
        }
    }
};

#endif