#ifndef _UI_OPTIONS_MENU
#define _UI_OPTIONS_MENU

#include "UIOptions.h"
#include "SwordGame.h"
#include <Settings.h>

enum OptionsSelection
{
    OptionsSelection_Sound,
    OptionsSelection_Music,
    OptionsSelection_Graphics,
    OptionsSelection_Window,
    OptionsSelection_EasySave,
    OptionsSelection_Back
};

class UIOptionsMenuCtrl : public IOptionHandler
{
private:
    UIOptions * uiOptions = NULL;
    IOptionHandler * prevHandler = NULL;
    SettingsData settings;

public:
    UIOptionsMenuCtrl(UIOptions * current)
    {
        if (current->handler != this)
        {
            prevHandler = current->handler;
        }
        uiOptions = current;
        uiOptions->handler = this;
        settings = Settings::Load();

        
        uiOptions->ClearOptions();
        uiOptions->SetTitle("OPTIONS");
        uiOptions->AddOption(TitleOption { 
            OptionsSelection_Sound,
            "Sound"
        });
        uiOptions->AddOption(TitleOption { 
            OptionsSelection_Music,
            "Music"
        });
        uiOptions->AddOption(TitleOption { 
            OptionsSelection_Graphics,
            "Graphics"
        });
        uiOptions->AddOption(TitleOption { 
            OptionsSelection_Window,
            "Window"
        });
        uiOptions->AddOption(TitleOption { 
            OptionsSelection_EasySave,
            "Easy Save"
        });
        uiOptions->AddOption(TitleOption { 
            OptionsSelection_Back,
            "Back"
        });
        Update();
    }

    void Update()
    {
        if (settings.soundMute)
        {
            uiOptions->SetOption(OptionsSelection_Sound, TitleOption { 
                OptionsSelection_Sound,
                "Sound: OFF"
            });
        }
        else
        {
            uiOptions->SetOption(OptionsSelection_Sound, TitleOption { 
                OptionsSelection_Sound,
                "Sound: ON"
            });
        }
        if (settings.musicMute)
        {
            uiOptions->SetOption(OptionsSelection_Music, TitleOption { 
                OptionsSelection_Music,
                "Music: OFF"
            });
        }
        else
        {
            uiOptions->SetOption(OptionsSelection_Music, TitleOption { 
                OptionsSelection_Music,
                "Music: ON"
            });
        }
        if (settings.graphicsHD)
        {
            uiOptions->SetOption(OptionsSelection_Graphics, TitleOption { 
                OptionsSelection_Graphics,
                "Graphics: HD"
            });
        }
        else
        {
            uiOptions->SetOption(OptionsSelection_Graphics, TitleOption { 
                OptionsSelection_Graphics,
                "Graphics: Retro"
            });
        }
        if (settings.windowed)
        {
            uiOptions->SetOption(OptionsSelection_Window, TitleOption { 
                OptionsSelection_Window,
                "Fullscreen: OFF"
            });
        }
        else
        {
            uiOptions->SetOption(OptionsSelection_Window, TitleOption { 
                OptionsSelection_Window,
                "Fullscreen: ON"
            });
        }
        if (settings.spawnFromSavePoint)
        {
            uiOptions->SetOption(OptionsSelection_EasySave, TitleOption { 
                OptionsSelection_EasySave,
                "Easy Save: OFF"
            });
        }
        else
        {
            uiOptions->SetOption(OptionsSelection_EasySave, TitleOption { 
                OptionsSelection_EasySave,
                "Easy Save: ON"
            });
        }
    }

    void OptionSelect(u8 selection)
    {
        switch (selection)
        {
            case OptionsSelection_Sound:
                settings.soundMute = !settings.soundMute;
                break;
            
            case OptionsSelection_Music:
                settings.musicMute = !settings.musicMute;
                break;
            
            case OptionsSelection_Graphics:
                settings.graphicsHD = !settings.graphicsHD;
                break;
            
            case OptionsSelection_Window:
                settings.windowed = !settings.windowed;
                break;
            
            case OptionsSelection_EasySave:
                settings.spawnFromSavePoint = !settings.spawnFromSavePoint;
                break;

            case OptionsSelection_Back:
                Back();
                return;
        }
        SaveSettings();
    }

    void OptionBack()
    {
        Back();
    }

    void SaveSettings()
    {
        Settings::Save(settings);
        SwordGame::Inst().LoadSettings();
        Update();
    }

    void Back()
    {
        uiOptions->handler = prevHandler;
        prevHandler->OptionBack();
    }

};

#endif