#ifndef _SCREEN_WON_H
#define _SCREEN_WON_H

#include "Screen.h"
#include <Textbox.h>
#include <RenderWindow.h>
#include <SwordGameScene.h>
#include <Camera.h>
#include <ui/UIProgress.h>
#include <SwordGame.h>
#include <SoundPlayer.h>
#include <MusicPlayer.h>

class ScreenWon : public Screen
{
private:
    Textbox txtTitle;
    UIProgress uiProgress;
    Camera cam;

public:
    void Init()
    {
        RenderWindow * window = RenderWindow::Current();

        txtTitle.SetAlignment(Vector2(0.5f, 0.5f));
        txtTitle.SetFontSize(32);
        txtTitle.SetFont("fonts/title");

        Vector3 pos = window->GetViewportPos(0.5f, 0.15f);
        txtTitle.transform.SetPosition(pos);
        txtTitle.SetText("QUEST COMPLETE!");

        pos.y += 32;
        pos.x -= 64;
        uiProgress.transform.SetPosition(pos);

        cam.SetCurrent();
        cam.backgroundColor = Vector3(0);

        AddEntity(&txtTitle);
        AddEntity(&uiProgress);
        
        SoundPlayer::Inst().Play("sfx/thunder.wav");
        MusicPlayer::Inst().Stop();
    }

    void Update(float dt)
    {
        Screen::Update(dt);

        if (Input::WasPressed(InputButton_START) || Input::WasKeyPressed(InputButton_A))
        {
            SwordGame::Inst().Credits();
        }
    }
};

#endif