#ifndef _SCREEN_STARTUP_H
#define _SCREEN_STARTUP_H

#include "Screen.h"
#include <Textbox.h>
#include <RenderWindow.h>
#include <SwordGame.h>
#include <MusicPlayer.h>
#include <loaders/MapPreloader.h>

class ScreenStartup : public Screen
{
private:
    Textbox txtTitle;
    u16 frame = 0;
    u32 stateTick = 0;

    enum StartupState
    {
        StartupState_Init,
        StartupState_PreloadWait,
        StartupState_Preloading,
        StartupState_Done
    };

    StartupState state = StartupState_Init;

public:
    void Init()
    {
        RenderWindow* window = RenderWindow::Current();

        txtTitle.SetAlignment(Vector2(0.5f, 0.5f));
        txtTitle.SetFontSize(24);
        txtTitle.SetFont("fonts/title");
        txtTitle.transform.SetPosition(window->GetViewportPos(0.5f, 0.5f));
        txtTitle.SetText("DALE BLACKWOOD\nCOMPLETELY COOKED GAMES");

        Camera::Current()->backgroundColor = Vector3(0);

        AddEntity(&txtTitle);
        txtTitle.SetVisible(false);

        stateTick = SDL_GetTicks();
    }

    void Update(float dt)
    {
        Screen::Update(dt);
        StartupState prevState = state;
        state = UpdateState();
        if (prevState != state)
        {
            stateTick = SDL_GetTicks();
        }
    }

    StartupState UpdateState()
    {
        switch (state)
        {
        case StartupState_Init:
            return UpdateInit();

        case StartupState_PreloadWait:
            return UpdatePreloadWait();

        case StartupState_Preloading:
            return UpdatePreloading();
        }
        return state;
    }

    StartupState UpdateInit()
    {
        if (SDL_GetTicks() - stateTick > 1000)
        {
            MusicPlayer::Inst().Play("theme");
            txtTitle.SetVisible(true);
            return StartupState_PreloadWait;
        }
        return StartupState_Init;
    }

    StartupState UpdatePreloadWait()
    {
        if (SDL_GetTicks() - stateTick > 100)
        {
            SwordGame::Inst().PreloadTitleMap();
            return StartupState_Preloading;
        }
        return StartupState_PreloadWait;
    }

    StartupState UpdatePreloading()
    {
        if (SDL_GetTicks() - stateTick > 1800 && txtTitle.IsVisible())
        {
            txtTitle.SetVisible(false);
        }

        MapPreloader* preloader = MapPreloader::Current();
        if (preloader != NULL && preloader->IsLoading())
        {
            preloader->Continue();
            return StartupState_Preloading;
        }

        if (SDL_GetTicks() - stateTick > 2100)
        {
            SwordGame::Inst().ToTitle();
            return StartupState_Done;
        }

        return StartupState_Preloading;
    }
};

#endif