#ifndef _SCREEN_LOAD_GAME_H
#define _SCREEN_LOAD_GAME_H

#include "Screen.h"
#include <Textbox.h>
#include <RenderWindow.h>
#include <SwordGameScene.h>
#include <Camera.h>
#include <SoundPlayer.h>
#include <Settings.h>
#include <MapEnvironment.h>
#include <Missions.h>
#include <SwordGame.h>
#include <loaders/MapPreloader.h>

class ScreenLoadGame : public Screen
{
private:
    Textbox txtTitle;
    float time = 0.0f;
    Camera cam;
    Vector3 titlePos = Vector3_ZERO;
    u8 loadPhase = 0;

public:
    void Init()
    {
        RenderWindow * window = RenderWindow::Current();

        txtTitle.SetAlignment(Vector2(1.0f, 1.0f));
        txtTitle.SetFontSize(16);
        txtTitle.SetFont("fonts/pixel");
        titlePos = window->GetViewportPos(1, 1) - Vector3(20, 20, 0);
        txtTitle.transform.SetPosition(titlePos);
        txtTitle.SetText("PRETENDING TO LOAD...");

        cam.SetCurrent();
        cam.backgroundColor = Vector3(0);

        AddEntity(&txtTitle);

        SoundPlayer::Inst().Play("sfx/thunder.wav");
    }

    void Update(float dt)
    {
        Screen::Update(dt);

        MapPreloader * preloader = MapPreloader::Current();
        if (preloader != NULL && preloader->IsLoading())
        {
            preloader->Continue();
        }

        txtTitle.transform.SetPosition(titlePos);
        txtTitle.transform.position.y += sinf(time) * 4.0f;

        time += dt;

        u8 newLoadPhase = (u8)(time * 0.5f);
        if (newLoadPhase != loadPhase)
        {
            loadPhase = newLoadPhase;
            switch (loadPhase)
            {
                case 1:
                {
                    Settings::Load();
                    MapEnvironment::Load();
                    Missions::Inst().Load();
                    break;
                }
                case 2:
                {
                    SwordGame::Inst().SetScene(new SwordGameScene());
                    break;
                }
            }
        }
    }
};

#endif