#ifndef _SCREEN_DIED_H
#define _SCREEN_DIED_H

#include "Screen.h"
#include <Textbox.h>
#include <RenderWindow.h>
#include <SwordGameScene.h>
#include <Camera.h>

class ScreenDied : public Screen
{
private:
    Textbox txtTitle;
    float time = 0.0f;
    Camera cam;

public:
    void Init()
    {
        RenderWindow * window = RenderWindow::Current();

        txtTitle.SetAlignment(Vector2(0.5f, 0.5f));
        txtTitle.SetFontSize(32);
        txtTitle.SetFont("fonts/title");
        txtTitle.transform.SetPosition(window->GetViewportPos(0.5f, 0.5f));
        txtTitle.SetText(GetDeadMessage());

        cam.SetCurrent();
        cam.backgroundColor = Vector3(0);

        AddEntity(&txtTitle);
        
        SoundPlayer::Inst().Play("sfx/dead.wav", 0.5f);
    }

    const char * GetDeadMessage()
    {
        switch (rand() % 16)
        {
            case 1: return "A SPLODE";
            case 2: return "CARKED IT";
            case 3: return "NO MORE";
            case 4: return "COOKED";
            case 5: return "YOLO'D";
            case 6: return "DONE";
            case 7: return "MUNTED";
            case 8: return "SHOT";
            case 9: return "SHUNTED IT";
            case 10: return "PUNTED";
            case 11: return "CHICKEN FEED";
        }
        return "DED";
    }

    void Update(float dt)
    {
        Screen::Update(dt);

        time += dt;
        if (time > 2.0f)
        {
            SwordGame::Inst().LoadGame();
        }
    }
};

#endif