#ifndef _SCREEN_CREDITS_H
#define _SCREEN_CREDITS_H

#include "Screen.h"
#include <Textbox.h>
#include <RenderWindow.h>
#include <SwordGameScene.h>
#include <Camera.h>
#include <MusicPlayer.h>
#include <FileSystem.h>
#include <SoundPlayer.h>

class ScreenCredits : public Screen
{
private:
    std::vector<Textbox*> textboxes;
    float time = 0.0f;
    Camera cam;
    std::string text = NULL;

public:
    void Init()
    {
        RenderWindow * window = RenderWindow::Current();

        text = FileSystem::LoadText("data/credits.txt");

        u16 lineStart = 0;
        char c;
        Vector3 pos = window->GetViewportPos(0.5f, 1.0f);
        char line[128];
        for (u16 i=0; i<UINT16_MAX; i++)
        {
            c = text[i];
            if (c == '\0')
            {
                break;
            }
            if (c == '\n')
            {
                if (i - lineStart > 1)
                {
                    strncpy(line, &text[lineStart], i - lineStart);
                    line[i - lineStart] = '\0';
                    Textbox * textbox = new Textbox();
                    textbox->SetAlignment(Vector2(0.5f, 0.5f));
                    textbox->SetFontSize(16);
                    textbox->SetFont("fonts/pixel");
                    textbox->transform.SetPosition(pos);
                    textbox->SetText(line);
                    textbox->SetCulling(false);
                    textbox->Added();
                    textboxes.push_back(textbox);
                    AddEntity(textbox);
                }
                pos.y += 35.0f;
                lineStart = i + 1;
                continue;
            }
        }

        cam.SetCurrent();
        cam.backgroundColor = Vector3(0);

        MusicPlayer::Inst().Stop();
        SoundPlayer::Inst().Play("sfx/fullsong.mp3", 0.5f);
    }

    void Update(float dt)
    {
        Screen::Update(dt);
        u16 textboxCount = textboxes.size();

        if (textboxes.back()->transform.position.y > 100.0f)
        {
            for (u16 i=0; i<textboxCount; i++)
            {
                textboxes[i]->Update(dt);
                textboxes[i]->transform.position.y -= dt * 20.0f;
            }

            if (Input::WasPressed(InputButton_START))
            {
                SwordGame::Inst().ToTitle();
            }
        }
    }

    void Render()
    {
        u16 textboxCount = textboxes.size();

        for (u16 i=0; i<textboxCount; i++)
        {
            textboxes[i]->Render();
        }
    }

    void OnUnload()
    {
        SoundPlayer::Inst().Stop();
    }
};

#endif