#ifndef _GAME_UI_H
#define _GAME_UI_H

#include <Entity.h>
#include <Textbox.h>
#include <Material.h>
#include <Sprite.h>
#include <MapEntityTypes.h>

#define UI_HEARTS_MAX 8

struct ActorInventory;

enum MessageType
{
    MessageType_Standard,
    MessageType_Silent,
    MessageType_Confirm
};

enum MessageStatus
{
    MessageStatus_None,
    MessageStatus_Pending,
    MessageStatus_Confirm,
    MessageStatus_Cancel
};

class GameUI : public Entity
{
private:
    static GameUI * current;

    Textbox txtMessage;
    Textbox txtPromptConfirm;
    Textbox txtPromptCancel;
    Textbox txtName;
    Ref<Material> uiMat;
    Sprite spriteHearts[UI_HEARTS_MAX];
    Sprite spriteHolding;
    Textbox txtChicken;
    Sprite spriteChicken;
    float messageTime = 0.0f;
    float displayTime = 0.0f;
    bool isWriting = false;
    float nextSoundTime = 0.0f;
    bool isTalking = false;
    u8 heartCount = 0;
    u8 holdItem = 0;
    u8 chickenCount = 0;
    MessageStatus messageStatus = MessageStatus_None;

public:
    static GameUI * Current();

    GameUI();

    void Added();
    void SetMessage(const char * message, float time, MessageType messageType = MessageType_Silent);
    void SetMessage(const char * title, const char * message, float time, MessageType messageType);
    void SetTalkMessage(const char * title, const char * message, float time, MessageType messageType);
    void SetPrompt(const char * text);
    void SetConfirmPrompt(const char * confirmText, const char * cancelText);
    void SetInventory(ActorInventory * inventory);
    void HideMessages();
    void Update(float dt);
    void Render();
    void FinishWriting();
    bool HasMessage() const;

    inline bool IsWriting() const { return isWriting; }
    inline bool IsTalking() const { return isTalking; }
    inline MessageStatus GetMessageStatus() const { return messageStatus; }
    void SetMessageStatus(MessageStatus value) { messageStatus = value; }

private:
    void SetText(const char * message, float time, Textbox * textbox);
};

#endif