#ifndef _PROP_TREE_H
#define _PROP_TREE_H

#include <MapEntity.h>
#include <MeshRenderer.h>
#include <MapEnvironment.h>
#include <Model3D.h>
#include <fx/FXer.h>

class PropTree : public MapEntity
{
private:
    Model3D model;
    
public:
    PropTree() : MapEntity(MapEntityType_Tree) {}

    void Start()
    {
        if (map->FlagIsSet(info->id))
        {
            Remove();
            return;
        }
        radius = 1.0f;
        MapEntity::Start();
        const MapLayerInfo * layerInfo = map->GetLayerInfo(info->x, info->z);
        const char * treeTex = MapStr::ReadText(layerInfo != NULL ? &layerInfo->textureTree : NULL, "mats/tree.png");
        model.LoadModel("models/tree.iqm");
        model.SetMaterial(treeTex);
        SetCollision(CollisionMode_Collide);
        useGravity = false;
        transform.Rotate(Vector3_UP, PI * (sin(transform.position.x * 0.1f) + cos(transform.position.z * 0.31f)));
        transform.scale = Vector3(1.05f + (0.15f * (sin(transform.position.x * 0.08f) + cos(transform.position.z * 0.31f))));
    }

    bool TakeHit(Entity * other, u8 power)
    {
        map->FlagSet(info->id, true);
        FXer::Fire(this, FXType_Grass, Vector3(0, 2.5f, 0));
        FXer::Fire(this, FXType_Grass, Vector3(0, 2.0f, 0));
        FXer::Fire(this, FXType_Woodchips, Vector3(0, 1, 0));
        Remove();
        return true;
    }

    void Render()
    {
        model.Render(transform.GetMatrix());
    }
};

#endif