#ifndef _PROP_SAVE_SWITCH_H
#define _PROP_SAVE_SWITCH_H

#include "PropSwitch.h"
#include "Save.h"
#include <ui/GameUI.h>

class PropSaveSwitch : public PropSwitch
{   
public:
    HashInt saveMapHash;

    PropSaveSwitch() : PropSwitch(MapEntityType_SaveSwitch) {}

    virtual void Start()
    {
        saveMapHash = Save::GetData()->map;
        PropSwitch::Start();
        transform.scale = Vector3(1.3f);
        staysOn = true;
        SetOn(saveMapHash > 0 && Save::GetSaveMap() == saveMapHash);
    }

    virtual void LoadModel()
    {
        PropSwitch::LoadModel(
            "models/switch.iqm",
            "models/save_on.png", 
            "models/save.png",
            "shaders/particle.dsh"
        );
        model.transform.position.y = 0.1f;
    }

    void SetOn(bool nowOn, float time = INFINITY)
    {
        if (nowOn != isOn)
        {
            isOn = nowOn;
            if (nowOn)
            {
                if (Save::GetSaveMap() != saveMapHash)
                {
                    Save::SetSaveMap(saveMapHash);
                    GameUI * ui = GameUI::Current();
                    if (ui != NULL)
                    {
                        ui->SetMessage("The universe sends you a sign that somehow, if it all goes tits up, you'll return to this place.", 3.0f, MessageType_Standard);
                    }
                    Save::SaveFile();
                }
            }
            model.SetMaterial(isOn ? materialOn : materialOff);
            map->FlagSet(info->id, isOn);
        }
        if (nowOn)
        {
            switchOnTime = time;
        }
    }

    inline bool IsOn() const { return isOn; }
};

#endif