#ifndef _PROP_OBELISK_H
#define _PROP_OBELISK_H

#include "PropSwitch.h"

class PropObelisk : public PropSwitch
{   
public:
    PropObelisk() : PropSwitch(MapEntityType_Obelisk) {}

    void LoadModel()
    {
        SetCollision(CollisionMode_Collide, Vector3(2.0f), Vector3(0, 0.6f, 0));
        PropSwitch::LoadModel(
            "models/obelisk.iqm",
            "models/obelisk_on.png", 
            "models/obelisk_off.png"
        );
    }

    void Update(float dt)
    {
        PropSwitch::Update(dt);
        if (isOn)
        {
            transform.Rotate(Vector3_UP, dt * 30.0f);
        }
    }

    void OnCollision(Entity * other)
    {
    }
};

#endif