#ifndef _PROP_GRASS_H
#define _PROP_GRASS_H

#include "Prop.h"
#include <fx/FXer.h>
#include <Maths.h>
#include <Actor.h>

class PropGrass : public Prop
{
public:

    PropGrass() : Prop(MapEntityType_Grass) {}

    void Start()
    {
        radius = 0.8f;
        Prop::Start();
        const MapLayerInfo * layerInfo = map->GetLayerInfo(info->x, info->z);
        const char * treeTex = MapStr::ReadText(layerInfo != NULL ? &layerInfo->textureTree : NULL, "mats/tree.png");
        LoadModel("models/grass.iqm", treeTex);
        SetCollision(CollisionMode_Collide, Vector3(radius * 2.0f), Vector3(0, 0.25f, 0));
        useGravity = false;
        canDespawn = false;
        collider->mass = 0;
        transform.Rotate(Vector3_UP, PI * (sin(transform.position.x * 0.1f) + cos(transform.position.z * 0.31f)));
    }

    bool TakeHit(Entity * other, u8 damage)
    {
        SetEnabled(false);
        if (Maths::RandI(3) == 0)
        {
            Actor * otherActor = (Actor*)other;
            if (MapEntityTypes::IsActor(otherActor->type))
            {
                if (otherActor->inventory.hearts < otherActor->inventory.maxHearts && Maths::RandI(2) == 1)
                {
                    FXer::Fire(this, FXType_Heart);
                }
                else
                {
                    FXer::Fire(this, FXType_Chicken);
                }
            }
        }
        FXer::Fire(this, FXType_Grass);
        return true;
    }
};

#endif